<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Models\Nasheed;
use Illuminate\Http\Request;

class NasheedController extends Controller
{
    /**
     * Display a listing of the nasheeds with pagination.
     */
    public function index(Request $request)
    {
        $perPage = $request->input('per_page', 10);

        $nasheeds = Nasheed::orderBy('order')
            ->orderBy('created_at', 'desc')
            ->paginate($perPage);

        // Transform the collection to include absolute URL for audio
        $nasheeds->getCollection()->transform(function ($nasheed) {
            return [
                'id' => $nasheed->id,
                'name' => $nasheed->name,
                'singer' => $nasheed->singer,
                'audio_url' => $nasheed->audio_path ? asset('storage/' . $nasheed->audio_path) : null,
                'lyrics' => $nasheed->lyrics,
                'order' => $nasheed->order,
                'created_at' => $nasheed->created_at,
            ];
        });

        return response()->json([
            'success' => true,
            'data' => $nasheeds
        ]);
    }
}
