<?php

namespace App\Http\Controllers;

use App\Models\Setting;
use App\Http\Requests\UpdateSettingsRequest;
use App\Http\Requests\ChangePasswordRequest;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;

class SettingController extends Controller
{
    public function index()
    {
        $logoPath = Setting::get('logo_path');
        $aboutApp = Setting::get('about_app');

        return view('settings.index', compact('logoPath', 'aboutApp'));
    }

    /**
     * Save logo + about app text.
     */
    public function update(UpdateSettingsRequest $request)
    {
        $validated = $request->validated();

        // Handle logo upload
        if ($request->hasFile('logo')) {
            $old = Setting::get('logo_path');
            if ($old) {
                Storage::disk('public')->delete($old);
            }
            $path = $request->file('logo')->store('settings', 'public');
            Setting::set('logo_path', $path);
        }

        // Save about text
        Setting::set('about_app', $request->input('about_app', ''));

        return redirect()->route('settings.index')
            ->with('saved', true);
    }

    /**
     * Change password.
     */
    public function changePassword(ChangePasswordRequest $request)
    {

        $user = Auth::user();
        $user->update(['password' => Hash::make($request->new_password)]);

        return redirect()->route('settings.index')
            ->with('saved', true);
    }
}
