<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StoreNasheedRequest extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   */
  public function authorize(): bool
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
   */
  public function rules(): array
  {
    return [
      'name' => 'required|string|max:1000',
      'singer' => 'required|string|max:1000',
      'audio' => 'nullable|file|mimes:mp3,wav,ogg,aac|max:51200',
      'lyrics' => 'nullable|string',
    ];
  }

  /**
   * Get custom messages for validator errors.
   *
   * @return array
   */
  public function messages(): array
  {
    return [
      'name.required' => 'اسم النشيد مطلوب',
      'singer.required' => 'اسم المنشد مطلوب',
      'audio.mimes' => 'يجب أن يكون الملف الصوتي بصيغة: mp3, wav, ogg, aac',
      'audio.max' => 'حجم الملف الصوتي يجب أن لا يتجاوز 50 ميجابايت',
    ];
  }
}
