<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateSettingsRequest extends FormRequest
{
  /**
   * Determine if the user is authorized to make this request.
   */
  public function authorize(): bool
  {
    return true;
  }

  /**
   * Get the validation rules that apply to the request.
   *
   * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
   */
  public function rules(): array
  {
    return [
      'logo' => 'nullable|image|mimes:png,jpg,jpeg,svg,webp|max:2048',
      'about_app' => 'nullable|string|max:2000',
    ];
  }

  /**
   * Get custom messages for validator errors.
   *
   * @return array
   */
  public function messages(): array
  {
    return [
      'logo.image' => 'يجب أن يكون الملف صورا',
      'logo.mimes' => 'يجب أن يكون الشعار بصيغة: png, jpg, jpeg, svg, webp',
      'logo.max' => 'حجم الشعار يجب أن لا يتجاوز 2 ميجابايت',
      'about_app.max' => 'نص "عن التطبيق" طويل جدا',
    ];
  }
}
