<x-guest-layout>
    <x-slot name="headerTitle">تأكيد</x-slot>

    <!-- Logo -->
    <div class="auth-logo-area" style="padding-bottom: 8px;">
        @php
        $drawerLogo = \App\Models\Setting::get('logo_path');
        @endphp
        @if($drawerLogo)
        <img src="{{ asset('storage/' . $drawerLogo) }}" alt="Tijan Logo"
            style="width: 60px; height: 68px; object-fit: contain;" />
        @else
        <x-tijan-logo width="60" height="68" />
        @endif
    </div>

    <div class="auth-body">
        <h1 class="auth-title">تحقق من بريدك الإلكتروني</h1>

        <p class="auth-subtitle">
            لقد أرسلنا رمز تحقق مكون من 4 أرقام إلى بريدك الإلكتروني.<br>
            يرجى إدخال الرمز في الحقل أدناه لإكمال عملية استعادة كلمة المرور
        </p>

        <!-- Session Status -->
        @if (session('status'))
            <div class="session-status">{{ session('status') }}</div>
        @endif

        <form method="POST" action="{{ route('password.store') }}" id="otp-form">
            @csrf
            <input type="hidden" name="token" value="{{ request()->route('token') ?? '' }}">
            <input type="hidden" name="email" value="{{ old('email', request()->email ?? '') }}">
            <input type="hidden" name="otp_combined" id="otp_combined">

            <!-- OTP Inputs -->
            <div class="otp-wrapper" id="otp-wrapper">
                <input type="text" class="otp-input" maxlength="1" inputmode="numeric" pattern="[0-9]" id="otp-1"
                    autocomplete="off">
                <input type="text" class="otp-input" maxlength="1" inputmode="numeric" pattern="[0-9]" id="otp-2"
                    autocomplete="off">
                <input type="text" class="otp-input" maxlength="1" inputmode="numeric" pattern="[0-9]" id="otp-3"
                    autocomplete="off">
                <input type="text" class="otp-input" maxlength="1" inputmode="numeric" pattern="[0-9]" id="otp-4"
                    autocomplete="off">
            </div>

            @error('otp_combined')
                <p class="form-error" style="text-align:center; margin-bottom:12px;">{{ $message }}</p>
            @enderror

            <p class="resend-text">
                لم تستلم الرمز؟
                <a href="{{ route('password.request') }}">اضغط هنا</a>
                أو
                <a href="{{ route('password.email') }}" id="resend-otp-btn">إعادة إرسال</a>
            </p>

            <div class="btn-row">
                <a href="{{ route('password.request') }}" class="btn-secondary"
                    style="text-align:center; text-decoration:none; display:flex; align-items:center; justify-content:center;">
                    إعادة إرسال
                </a>
                <button type="submit" class="btn-primary" id="otp-confirm-btn">
                    تأكيد
                </button>
            </div>
        </form>
    </div>

    <!-- Success Modal -->
    <div class="modal-overlay" id="success-modal">
        <div class="modal-box">
            <button class="modal-close" id="modal-close-btn" type="button">✕</button>
            <div class="modal-icon">✨</div>
            <h2 class="modal-title">تم تأكيد الحساب بنجاح</h2>
            <p class="modal-subtitle">أهلاً بك! يمكنك الآن المتابعة</p>
            <a href="{{ route('login') }}" class="btn-primary"
                style="display:block; text-decoration:none; text-align:center;" id="modal-continue-btn">
                متابعة
            </a>
        </div>
    </div>

    <script>
        // OTP auto-advance
        const otpInputs = document.querySelectorAll('.otp-input');

        otpInputs.forEach((input, index) => {
            input.addEventListener('input', (e) => {
                const val = e.target.value.replace(/\D/g, '');
                e.target.value = val;
                if (val && index < otpInputs.length - 1) {
                    otpInputs[index + 1].focus();
                }
            });

            input.addEventListener('keydown', (e) => {
                if (e.key === 'Backspace' && !e.target.value && index > 0) {
                    otpInputs[index - 1].focus();
                }
            });

            input.addEventListener('paste', (e) => {
                e.preventDefault();
                const paste = (e.clipboardData || window.clipboardData).getData('text').replace(/\D/g, '');
                paste.split('').forEach((char, i) => {
                    if (otpInputs[i]) otpInputs[i].value = char;
                });
                const next = Math.min(paste.length, otpInputs.length - 1);
                otpInputs[next].focus();
            });
        });

        // Combine OTP on submit
        document.getElementById('otp-form').addEventListener('submit', function (e) {
            const combined = Array.from(otpInputs).map(i => i.value).join('');
            document.getElementById('otp_combined').value = combined;
        });

        // Modal close
        document.getElementById('modal-close-btn').addEventListener('click', () => {
            document.getElementById('success-modal').classList.remove('active');
        });

        // Show modal if success (triggered by server)
        @if(session('otp_verified'))
            document.getElementById('success-modal').classList.add('active');
        @endif
    </script>
</x-guest-layout>