<!DOCTYPE html>
<html lang="ar" dir="rtl">

<head>
    <meta charset="utf-8">
    <meta name="viewport" content="width=device-width, initial-scale=1">
    <meta name="csrf-token" content="{{ csrf_token() }}">

    <title>{{ $title ?? '' }} - {{ 'Tijan' }}</title>

    <!-- Fonts -->
    <link rel="preconnect" href="https://fonts.googleapis.com">
    <link href="https://fonts.googleapis.com/css2?family=Cairo:wght@300;400;500;600;700;800&display=swap"
        rel="stylesheet">

    <style>
        *,
        *::before,
        *::after {
            box-sizing: border-box;
            margin: 0;
            padding: 0;
        }

        :root {
            --green-dark: #1A3C2E;
            --green-mid: #1F4D38;
            --green-btn: #1B4332;
            --green-hover: #163829;
            --green-light: #E8F0EC;
            --gold: #C9A84C;
            --text-dark: #1A1A1A;
            --text-mid: #4A4A4A;
            --text-light: #7A7A7A;
            --border: #D8D8D8;
            --bg: #F5F5F5;
            --white: #FFFFFF;
            --error: #D32F2F;
            --radius: 12px;
            --shadow: 0 4px 24px rgba(0, 0, 0, 0.10);
        }

        html,
        body {
            height: 100%;
            font-family: 'Cairo', sans-serif;
            background: var(--bg);
            color: var(--text-dark);
            direction: rtl;
        }

        .auth-wrapper {
            min-height: 100vh;
            display: flex;
            align-items: center;
            justify-content: center;
            padding: 24px 16px;
            background: var(--bg);
        }

        .auth-card {
            width: 100%;
            background: var(--white);
            border-radius: var(--radius);
            box-shadow: var(--shadow);
            overflow: hidden;
        }

        /* Header strip */
        .auth-header-bar {
            background: var(--green-dark);
            color: var(--white);
            text-align: center;
            padding: 10px 16px;
            font-size: 13px;
            font-weight: 500;
            letter-spacing: 0.3px;
        }

        /* Logo area */
        .auth-logo-area {
            display: flex;
            flex-direction: column;
            align-items: center;
            padding: 28px 24px 16px;
        }

        .auth-logo-area img {
            width: 72px;
            height: auto;
            margin-bottom: 8px;
        }

        .auth-brand-name {
            font-size: 26px;
            font-weight: 800;
            color: var(--text-dark);
            letter-spacing: 1px;
        }

        /* Card body */
        .auth-body {
            padding: 8px 28px 32px;
        }

        .auth-title {
            font-size: 22px;
            font-weight: 700;
            color: var(--text-dark);
            text-align: center;
            margin-bottom: 24px;
        }

        .auth-subtitle {
            font-size: 14px;
            color: var(--text-mid);
            text-align: center;
            line-height: 1.7;
            margin-bottom: 24px;
        }

        /* Form elements */
        .form-group {
            margin-bottom: 16px;
        }

        .form-label {
            display: block;
            font-size: 13px;
            font-weight: 600;
            color: var(--text-mid);
            margin-bottom: 6px;
            text-align: right;
        }

        .form-input {
            width: 100%;
            padding: 12px 14px;
            border: 1.5px solid var(--border);
            border-radius: 8px;
            font-family: 'Cairo', sans-serif;
            font-size: 14px;
            color: var(--text-dark);
            background: var(--white);
            outline: none;
            transition: border-color 0.2s, box-shadow 0.2s;
            text-align: right;
            direction: rtl;
        }

        .form-input::placeholder {
            color: #BBBBBB;
            font-size: 13px;
        }

        .form-input:focus {
            border-color: var(--green-btn);
            box-shadow: 0 0 0 3px rgba(27, 67, 50, 0.10);
        }

        .form-input.error {
            border-color: var(--error);
        }

        .form-error {
            font-size: 12px;
            color: var(--error);
            margin-top: 4px;
            text-align: right;
        }

        /* Checkbox row */
        .form-check-row {
            display: flex;
            align-items: center;
            gap: 8px;
            margin-bottom: 8px;
            flex-direction: row-reverse;
            justify-content: flex-end;
        }

        .form-check-row input[type="checkbox"] {
            width: 16px;
            height: 16px;
            accent-color: var(--green-btn);
            cursor: pointer;
        }

        .form-check-row label {
            font-size: 13px;
            color: var(--text-mid);
            cursor: pointer;
        }

        /* Forgot link */
        .forgot-link {
            display: block;
            text-align: right;
            font-size: 13px;
            color: var(--text-light);
            text-decoration: none;
            margin-bottom: 20px;
            transition: color 0.2s;
        }

        .forgot-link:hover {
            color: var(--green-btn);
        }

        /* Primary button */
        .btn-primary {
            width: 100%;
            padding: 14px;
            background: var(--green-btn);
            color: var(--white);
            border: none;
            border-radius: 8px;
            font-family: 'Cairo', sans-serif;
            font-size: 16px;
            font-weight: 700;
            cursor: pointer;
            transition: background 0.2s, transform 0.1s;
            letter-spacing: 0.5px;
        }

        .btn-primary:hover {
            background: var(--green-hover);
        }

        .btn-primary:active {
            transform: scale(0.99);
        }

        /* Secondary button */
        .btn-secondary {
            width: 100%;
            padding: 13px;
            background: var(--white);
            color: var(--text-mid);
            border: 1.5px solid var(--border);
            border-radius: 8px;
            font-family: 'Cairo', sans-serif;
            font-size: 15px;
            font-weight: 600;
            cursor: pointer;
            transition: background 0.2s, border-color 0.2s;
        }

        .btn-secondary:hover {
            background: var(--green-light);
            border-color: var(--green-btn);
        }

        /* Two-button row */
        .btn-row {
            display: grid;
            grid-template-columns: 1fr 1fr;
            gap: 12px;
            margin-top: 8px;
        }

        /* Session status */
        .session-status {
            background: #E8F5E9;
            border: 1px solid #A5D6A7;
            color: #2E7D32;
            padding: 10px 14px;
            border-radius: 8px;
            font-size: 13px;
            margin-bottom: 16px;
            text-align: right;
        }

        /* OTP inputs */
        .otp-wrapper {
            display: flex;
            justify-content: center;
            gap: 12px;
            margin-bottom: 20px;
            direction: ltr;
        }

        .otp-input {
            width: 56px;
            height: 60px;
            border: 1.5px solid var(--border);
            border-radius: 10px;
            font-family: 'Cairo', sans-serif;
            font-size: 22px;
            font-weight: 700;
            text-align: center;
            color: var(--text-dark);
            outline: none;
            transition: border-color 0.2s, box-shadow 0.2s;
            background: #FAFAFA;
        }

        .otp-input:focus {
            border-color: var(--green-btn);
            box-shadow: 0 0 0 3px rgba(27, 67, 50, 0.10);
            background: var(--white);
        }

        .resend-text {
            text-align: center;
            font-size: 13px;
            color: var(--text-light);
            margin-bottom: 20px;
        }

        .resend-text a {
            color: var(--green-btn);
            text-decoration: none;
            font-weight: 600;
        }

        /* Modal overlay */
        .modal-overlay {
            display: none;
            position: fixed;
            inset: 0;
            background: rgba(0, 0, 0, 0.45);
            z-index: 1000;
            align-items: center;
            justify-content: center;
            padding: 24px;
        }

        .modal-overlay.active {
            display: flex;
        }

        .modal-box {
            background: var(--white);
            border-radius: 16px;
            padding: 32px 28px;
            max-width: 320px;
            width: 100%;
            text-align: center;
            position: relative;
            box-shadow: 0 8px 40px rgba(0, 0, 0, 0.18);
            animation: modalIn 0.25s ease;
        }

        @keyframes modalIn {
            from {
                opacity: 0;
                transform: scale(0.92) translateY(12px);
            }

            to {
                opacity: 1;
                transform: scale(1) translateY(0);
            }
        }

        .modal-close {
            position: absolute;
            top: 14px;
            left: 16px;
            background: none;
            border: none;
            font-size: 20px;
            color: var(--text-light);
            cursor: pointer;
            line-height: 1;
        }

        .modal-icon {
            font-size: 36px;
            margin-bottom: 12px;
        }

        .modal-title {
            font-size: 20px;
            font-weight: 800;
            color: var(--text-dark);
            margin-bottom: 8px;
        }

        .modal-subtitle {
            font-size: 14px;
            color: var(--text-mid);
            margin-bottom: 24px;
            line-height: 1.6;
        }

        /* Responsive */
        @media (max-width: 440px) {
            .auth-card {
                border-radius: 0;
                min-height: 100vh;
            }

            .auth-wrapper {
                padding: 0;
                align-items: flex-start;
            }
        }
    </style>
</head>

<body>
    <div class="auth-wrapper">
        <div class="auth-card">
            {{ $slot }}
        </div>
    </div>
</body>

</html>