<x-admin-layout>
  <x-slot name="title">إضافة نشيد جديد</x-slot>

  {{-- Page heading --}}
  <div class="admin-page-heading">
    <a href="{{ route('nasheeds.index') }}" class="back-btn" aria-label="رجوع">›</a>
    <h1>إضافة نشيد جديد</h1>
  </div>

  <div class="admin-content">

    @if($errors->any())
      <div class="flash-error">
        @foreach($errors->all() as $error)
          <div>• {{ $error }}</div>
        @endforeach
      </div>
    @endif

    <form method="POST" action="{{ route('nasheeds.store') }}" enctype="multipart/form-data" id="create-nasheed-form">
      @csrf

      {{-- Name --}}
      <div class="form-group">
        <label class="form-label" for="name">
          أسم النشيد <span class="required">*</span>
        </label>
        <input type="text" id="name" name="name" class="form-input {{ $errors->has('name') ? 'is-invalid' : '' }}"
          placeholder="أدخل أسم النشيد" value="{{ old('name') }}" required autocomplete="off">
        @error('name')
          <div class="form-error">{{ $message }}</div>
        @enderror
      </div>

      {{-- Singer --}}
      <div class="form-group">
        <label class="form-label" for="singer">
          أسم المنشد <span class="required">*</span>
        </label>
        <input type="text" id="singer" name="singer" class="form-input {{ $errors->has('singer') ? 'is-invalid' : '' }}"
          placeholder="أدخل أسم المنشد" value="{{ old('singer') }}" required autocomplete="off">
        @error('singer')
          <div class="form-error">{{ $message }}</div>
        @enderror
      </div>

      {{-- Audio file --}}
      <div class="form-group">
        <label class="form-label" for="audio">الملف الصوتي</label>
        <div class="file-upload-zone" id="audio-drop-zone" ondragover="handleDragOver(event)"
          ondragleave="handleDragLeave(event)" ondrop="handleDrop(event)">
          <input type="file" id="audio" name="audio" accept=".mp3,.wav,.ogg,.aac" onchange="handleFileSelect(this)">
          <span class="file-upload-icon">⬆️</span>
          <div class="file-upload-text">رفع ملف صوتي</div>
          <div class="file-upload-hint">(MP3, WAV)</div>
          <div class="file-selected-name" id="selected-file-name" style="display:none;"></div>
        </div>
        @error('audio')
          <div class="form-error">{{ $message }}</div>
        @enderror
      </div>

      {{-- Lyrics --}}
      <div class="form-group">
        <label class="form-label" for="lyrics">كلمات النشيد</label>
        <textarea id="lyrics" name="lyrics" class="form-input {{ $errors->has('lyrics') ? 'is-invalid' : '' }}"
          placeholder="أدخل كلمات النشيد" rows="4">{{ old('lyrics') }}</textarea>
        @error('lyrics')
          <div class="form-error">{{ $message }}</div>
        @enderror
      </div>

      {{-- Submit --}}
      <button type="submit" class="btn-primary full" id="btn-submit-create" style="margin-top:8px;">
        نشر
      </button>
    </form>
  </div>

  <script>
    function handleFileSelect(input) {
      const nameEl = document.getElementById('selected-file-name');
      if (input.files && input.files[0]) {
        nameEl.textContent = '📎 ' + input.files[0].name;
        nameEl.style.display = 'block';
      } else {
        nameEl.style.display = 'none';
      }
    }

    function handleDragOver(e) {
      e.preventDefault();
      document.getElementById('audio-drop-zone').classList.add('dragover');
    }

    function handleDragLeave(e) {
      document.getElementById('audio-drop-zone').classList.remove('dragover');
    }

    function handleDrop(e) {
      e.preventDefault();
      document.getElementById('audio-drop-zone').classList.remove('dragover');
      const files = e.dataTransfer.files;
      if (files.length > 0) {
        const input = document.getElementById('audio');
        const dt = new DataTransfer();
        dt.items.add(files[0]);
        input.files = dt.files;
        handleFileSelect(input);
      }
    }
  </script>
</x-admin-layout>