<x-admin-layout>
  <x-slot name="title">الأعدادات</x-slot>
  <x-slot name="pageTitle">الأعدادات</x-slot>

  {{-- Page heading --}}
  <div class="admin-page-heading">
    <a href="{{ route('nasheeds.index') }}" class="back-btn" aria-label="رجوع">›</a>
    <h1>الأعدادات</h1>
  </div>

  <div class="admin-content">

    {{-- ── Logo section ── --}}
    <div class="settings-logo-section">
      {{-- Logo preview --}}
      <div class="settings-logo-preview" id="logo-preview-wrap">
        @if($logoPath)
          <img src="{{ asset('storage/' . $logoPath) }}" alt="Logo" id="logo-img">
        @else
          <x-tijan-logo width="80" height="90" id="logo-img-default" />
        @endif
        <div class="settings-logo-label">Logo</div>
      </div>

      {{-- Edit logo button --}}
      <form method="POST" action="{{ route('settings.update') }}" enctype="multipart/form-data" id="logo-form">
        @csrf
        <input type="file" id="logo-file-input" name="logo" accept="image/*" style="display:none;"
          onchange="previewLogo(this); document.getElementById('logo-form').submit();">
        {{-- Keep about_app value when only uploading logo --}}
        <input type="hidden" name="about_app" value="{{ $aboutApp ?? '' }}">

        <button type="button" class="btn-edit-logo" id="btn-edit-logo"
          onclick="document.getElementById('logo-file-input').click()">
          🖼️ تعديل اللوجو
        </button>
      </form>
    </div>

    {{-- ── About App ── --}}
    <form method="POST" action="{{ route('settings.update') }}" enctype="multipart/form-data" id="about-form">
      @csrf

      <div class="settings-section-label">حول التطبيق</div>

      <div class="form-group">
        <textarea id="about_app" name="about_app" class="form-input" placeholder="أدخل تعريف التطبيق"
          rows="4">{{ old('about_app', $aboutApp) }}</textarea>
        @error('about_app')
          <div class="form-error">{{ $message }}</div>
        @enderror
      </div>

   

      <div class="password-section" id="password-section" style="{{ session('open_password') ? '' : 'display:none;' }}">
          {{-- This section submits to a separate endpoint --}}
      </div>

      {{-- Save button for about_app --}}
      <button type="submit" class="btn-primary full" id="btn-save-settings" style="margin-top:16px;">
        حفظ
      </button>
    </form>
   {{-- ── Change Password (collapsible) ── --}}
      <div class="settings-section-label" style="margin-top:15px;">
        <button type="button" class="collapsible-toggle" id="password-toggle" onclick="togglePasswordSection()"
          aria-expanded="{{ session('open_password') ? 'true' : 'false' }}">
          <span>تغيير كلمة المرور</span>
          <span class="toggle-arrow" id="toggle-arrow">{{ session('open_password') ? '▲' : '▼' }}</span>
        </button>
      </div>
    {{-- ── Password form (separate) ── --}}
    <form method="POST" action="{{ route('settings.password') }}" id="password-form"
      style="{{ session('open_password') ? '' : 'display:none;' }}">
      @csrf

      @if($errors->has('current_password'))
        <div class="flash-error" style="margin-bottom:12px;">{{ $errors->first('current_password') }}</div>
      @endif

     
      <div class="form-group">
        <label class="form-label" for="new_password">كلمة المرور الجديدة</label>
        <input type="password" id="new_password" name="new_password"
          class="form-input {{ $errors->has('new_password') ? 'is-invalid' : '' }}" placeholder="••••••••••••••••"
          autocomplete="new-password">
        @error('new_password')
          <div class="form-error">{{ $message }}</div>
        @enderror
      </div>

      <div class="form-group">
        <label class="form-label" for="new_password_confirmation">تأكيد كلمة المرور</label>
        <input type="password" id="new_password_confirmation" name="new_password_confirmation" class="form-input"
          placeholder="••••••••••••••••" autocomplete="new-password">
      </div>

      <button type="submit" class="btn-primary full" id="btn-save-password">
        حفظ
      </button>
    </form>
  </div>

  {{-- ── Success modal ── --}}
  <div class="modal-overlay" id="success-modal" style="{{ session('saved') ? 'display:flex;' : '' }}">
    <div class="modal-box" style="text-align:center;">
      <button class="modal-close" onclick="closeSuccessModal()" aria-label="إغلاق">✕</button>
      <div style="font-size:40px; margin-bottom:12px; color: var(--gold);">✦</div>
      <div class="modal-title" style="font-size:20px;">تم تأكيد الحفظ بنجاح</div>
    </div>
  </div>

  <style>
    /* ── Settings-specific styles ── */
    .settings-logo-section {
      display: flex;
      flex-direction: column;
      align-items: center;
      padding: 20px 0 16px;
      border-bottom: 1px solid var(--border);
      margin-bottom: 20px;
    }

    .settings-logo-preview {
      display: flex;
      flex-direction: column;
      align-items: center;
      gap: 6px;
      margin-bottom: 14px;
    }

    .settings-logo-preview img,
    .settings-logo-preview svg {
      width: 80px;
      height: auto;
    }

    .settings-logo-label {
      font-size: 12px;
      color: var(--text-light);
      font-weight: 500;
      letter-spacing: 0.5px;
    }

    .btn-edit-logo {
      display: inline-flex;
      align-items: center;
      gap: 6px;
      padding: 9px 18px;
      background: var(--white);
      color: var(--green-btn);
      border: 1.5px solid var(--green-btn);
      border-radius: 8px;
      font-family: 'Cairo', sans-serif;
      font-size: 14px;
      font-weight: 600;
      cursor: pointer;
      transition: background 0.2s;
    }

    .btn-edit-logo:hover {
      background: var(--green-light);
    }

    .settings-section-label {
      font-size: 15px;
      font-weight: 700;
      color: var(--text-dark);
      margin-bottom: 10px;
    }

    .collapsible-toggle {
      width: 100%;
      display: flex;
      align-items: center;
      justify-content: space-between;
      background: none;
      border: none;
      font-family: 'Cairo', sans-serif;
      font-size: 15px;
      font-weight: 700;
      color: var(--text-dark);
      cursor: pointer;
      padding: 0;
      text-align: right;
    }

    .toggle-arrow {
      font-size: 13px;
      color: var(--text-light);
      transition: transform 0.2s;
    }

    .password-section {
      margin-top: 12px;
    }

    /* Gold sparkle icon */
    .modal-box .modal-sparkle {
      font-size: 40px;
      color: var(--gold);
      margin-bottom: 12px;
    }
  </style>

  <script>
    // ── Logo preview ──
    function previewLogo(input) {
      if (input.files && input.files[0]) {
        const reader = new FileReader();
        reader.onload = function (e) {
          const wrap = document.getElementById('logo-preview-wrap');
          let img = wrap.querySelector('img#logo-img');
          if (!img) {
            img = document.createElement('img');
            img.id = 'logo-img';
            img.alt = 'Logo';
            const svg = wrap.querySelector('svg');
            if (svg) svg.replaceWith(img);
            else wrap.insertBefore(img, wrap.querySelector('.settings-logo-label'));
          }
          img.src = e.target.result;
          img.style.width = '80px';
        };
        reader.readAsDataURL(input.files[0]);
      }
    }

    // ── Password collapsible ──
    function togglePasswordSection() {
      const section = document.getElementById('password-form');
      const arrow = document.getElementById('toggle-arrow');
      const btn = document.getElementById('password-toggle');
      const isOpen = section.style.display !== 'none';

      section.style.display = isOpen ? 'none' : 'block';
      arrow.textContent = isOpen ? '▼' : '▲';
      btn.setAttribute('aria-expanded', String(!isOpen));
    }

    // ── Success modal ──
    function closeSuccessModal() {
      document.getElementById('success-modal').style.display = 'none';
    }

    // Auto-close success modal after 2.5s
    const successModal = document.getElementById('success-modal');
    if (successModal && successModal.style.display === 'flex') {
      setTimeout(closeSuccessModal, 4000);
    }

    // Close on overlay click
    successModal && successModal.addEventListener('click', function (e) {
      if (e.target === this) closeSuccessModal();
    });
  </script>
</x-admin-layout>