<?php

use App\Http\Controllers\ProfileController;
use App\Http\Controllers\NasheedController;
use App\Http\Controllers\SettingController;
use Illuminate\Support\Facades\Route;

Route::middleware('auth')->group(function () {
    // Main Page (Nasheeds)
    Route::get('/', [NasheedController::class, 'index'])->name('home');
    Route::get('/nasheeds', [NasheedController::class, 'index'])->name('nasheeds.index');

    // Nasheeds Admin
    Route::resource('nasheeds', NasheedController::class)->except(['index']);
    Route::post('/nasheeds/reorder', [NasheedController::class, 'updateOrder'])->name('nasheeds.reorder');

    // Profile Settings
    Route::get('/profile', [ProfileController::class, 'edit'])->name('profile.edit');
    Route::patch('/profile', [ProfileController::class, 'update'])->name('profile.update');
    Route::delete('/profile', [ProfileController::class, 'destroy'])->name('profile.destroy');

    // App Settings
    Route::get('/settings', [SettingController::class, 'index'])->name('settings.index');
    Route::post('/settings', [SettingController::class, 'update'])->name('settings.update');
    Route::post('/settings/password', [SettingController::class, 'changePassword'])->name('settings.password');

    Route::get('/dashboard', function () {
        return view('dashboard');
    })->middleware(['verified'])->name('dashboard');
});

// Demo route for OTP page preview (remove in production)
Route::get('/otp-demo', function () {
    return view('auth.verify-email');
})->name('otp.demo');

require __DIR__ . '/auth.php';
